<!DOCTYPE HTML>
<?PHP
	require 'functions.php';
	checkLogin();
	$db_link = connect();

	//Generate timestamp
	$timestamp = time();

    $cust_nameErr = $cust_addressErr = $CustomerGNDErr = $CustNICErr = $cust_dobErr = $custsex_idErr = $custmarried_idErr = $cust_phone1Err = $loanroute_idNCErr = "";

    $cust_name = $cust_address = $Period_of_residenceAddM = $Period_of_residenceAddY = $CustomerGND = $CustLocation = $CustNIC = $cust_dob = $custsex_id = $custmarried_id = $cust_phone = $cust_occup = $cust_email = $loanroute_idNC = "";

	//CREATE-Button
	if (isset($_POST['create'])){

		//Sanitize user input
		$cust_no = sanitize($db_link, $_POST['cust_no']);
        
        if (empty($_POST["cust_name"])) {
            $cust_nameErr = "Name is required";
        } else {
            $cust_name = sanitize($db_link, $_POST['cust_name']);
                // check if name only contains letters and whitespace
                if (!preg_match("/^[a-zA-Z-' ]*$/",$cust_name)) {
                    $cust_nameErr = "Only letters and white space allowed";
                }
        }
        
        if (empty($_POST["cust_address"])) {
            $cust_addressErr = "Address is required";
        } else {
            $cust_address = sanitize($db_link, $_POST['cust_address']);
        }
		
        if (empty($_POST["cAdRePMo"])) {
            $Period_of_residenceAddM = "";
        } else {
            $Period_of_residenceAddM = sanitize($db_link, $_POST['cAdRePMo']);
        }
		
		if (empty($_POST["cAdRePYe"])) {
            $Period_of_residenceAddY = "";
        } else {
            $Period_of_residenceAddY = sanitize($db_link, $_POST['cAdRePYe']);
        }
        
        if (empty($_POST["CustomerGND"])) {
            $CustomerGNDErr = "GND is required";
        } else {
            $CustomerGND = sanitize($db_link, $_POST['CustomerGND']);
        }
		
		if (empty($_POST["CustLocation"])) {
            $CustLocation = "";
        } else {
            $CustLocation = sanitize($db_link, $_POST['CustLocation']);
        }
        
        $CustLocationLat = sanitize($db_link, $_POST['lat']);
        $CustLocationLng = sanitize($db_link, $_POST['lng']);
		
		if (empty($_POST["cust_nic"])) {
            $CustNICErr = "NIC is required";
        } else {
            $CustNIC = sanitize($db_link, $_POST['cust_nic']);
            // check if name only contains letters and whitespace
                if (!preg_match("/^[a-zA-Z0-9']*$/",$CustNIC)) {
                    $CustNICErr = "Only letters and numbers allowed";
                }
        }
        
        if (empty($_POST["cust_dob"])) {
            $cust_dobErr = "DOB is required";
        } else {
            $cust_dob = strtotime(sanitize($db_link, $_POST['cust_dob']));
        }
        
        if (empty($_POST["custsex_id"])) {
            $custsex_idErr = "Gender is required";
        } else {
            $custsex_id = sanitize($db_link, $_POST['custsex_id']);
        }
        
        if ($_POST['custmarried_id']){
            $custmarried_id = sanitize($db_link, $_POST['custmarried_id']);     
             if ($custmarried_id == '0')
                {
                    $custmarried_idErr = "Marital Status is required";
                }         
        }
        else{
            $custmarried_id = '0';
            $custmarried_idErr = "Marital Status is required";
        }
        
        $partner_Name = sanitize($db_link, $_POST['partnerName']);
        $partner_NIC = sanitize($db_link, $_POST['partnerNIC']);
        
        if (empty($_POST["cust_occup"])) {
            $cust_occup = "";
        } else {
             $cust_occup = sanitize($db_link, $_POST['cust_occup']);
        }
        
        if (empty($_POST["ConNu1"])) {
            $cust_phone1Err = "Required";
        } else {
            $cust_phone = sanitize($db_link, $_POST['ConNu1']."-".$_POST['ConNu2']);
        }
		
		if (empty($_POST["cust_email"])) {
            $cust_email = "";
        } else {
             $cust_email = sanitize($db_link, $_POST['cust_email']);
        }
        
        if ($_POST['loanroute_idNC']){
            $loanroute_idNC = sanitize($db_link, $_POST['loanroute_idNC']);     
             if ($loanroute_idNC == '0')
                {
                    $loanroute_idNCErr = "Required";
                }         
        }
        else{
            $loanroute_idNC = '0';
            $loanroute_idNCErr = "Required";
        }

        $cust_since = strtotime(sanitize($db_link, $_POST['cust_since']));
	

        //Refer to cust_new_pic.php
        if (empty($cust_nameErr) && empty($cust_addressErr) && empty($CustomerGNDErr) && empty($CustNICErr) && empty($cust_dobErr) && empty($custsex_idErr) && empty($custmarried_idErr) && empty($cust_phone1Err) && empty($loanroute_idNCErr) ) { 
            
		//Insert new Customer into CUSTOMER
		$sql_insert = "INSERT INTO customer (cust_no, cust_name, cust_address, period_of_residenceAddM, period_of_residenceAddY, customerGND, CustLocation, CustLocationLat, CustLocationLng, custNIC, cust_dob,  custsex_id, custmarried_id, partner_Name, partner_NIC, cust_occup, cust_phone, cust_email, cust_since, loanroute_id,  cust_active, cust_lastupd, user_id) VALUES ('$cust_no', '$cust_name', '$cust_address', '$Period_of_residenceAddM', '$Period_of_residenceAddY', '$CustomerGND', '$CustLocation', '$CustLocationLat', '$CustLocationLng', '$CustNIC', '$cust_dob', '$custsex_id', $custmarried_id, '$partner_Name', '$partner_NIC', '$cust_occup', '$cust_phone', '$cust_email', $cust_since, $loanroute_idNC, '1', $timestamp, $_SESSION[log_id])";
		$query_insert = mysqli_query($db_link, $sql_insert);
		checkSQL($db_link, $query_insert);
        /* cust_lastsub, */
            
		//Get new Customer's ID from CUSTOMER
		$sql_maxid = "SELECT MAX(cust_id) FROM customer";
		$query_maxid = mysqli_query($db_link, $sql_maxid);
		checkSQL($db_link, $query_maxid);
		$maxid = mysqli_fetch_assoc($query_maxid);
		$_SESSION['cust_id'] = $maxid['MAX(cust_id)'];

		//Create a new empty SAVBALANCE entry for the new customer
		$sql_insert_savbal = "INSERT INTO savbalance (cust_id, savbal_balance, savbal_date, savbal_created, user_id) VALUES ('$_SESSION[cust_id]', '0', '$timestamp', '$timestamp', '$_SESSION[log_id]')";
		$query_insert_savbal = mysqli_query($db_link, $sql_insert_savbal);
		checkSQL($db_link, $query_insert_savbal);
		
		header('Location: cust_new_pic.php?from=new');
        }
	}
 
	//Select Marital Status for Drop-down-Menu
	$sql_mstat = "SELECT * FROM custmarried";
	$query_mstat = mysqli_query($db_link, $sql_mstat);
	checkSQL($db_link, $query_mstat);
        
    //Select loan route from loanroute
    $sql_loanrouteNC = "SELECT * FROM loanroute";
    $query_loanrouteNC = mysqli_query($db_link, $sql_loanrouteNC);
    checkSQL($db_link, $query_loanrouteNC);

	//Select Sexes from custsex for dropdown-menu
	$sql_sex = "SELECT * FROM custsex";
	$query_sex = mysqli_query($db_link, $sql_sex);
	checkSQL($db_link, $query_sex);

    //Select Grama Niladhari Division 
    $sql_newCselectGND = "SELECT * FROM gramaniladharidivision";
	$query_newCselectGND = mysqli_query($db_link, $sql_newCselectGND);
	checkSQL($db_link, $query_sex);

	//Build new CUST_NO
	$newCustNo = buildCustNo($db_link);
?>

<html>
	<?PHP includeHead('New Customer',0) ?> 
	</head>
	<body onload="getLocation()">

		<!-- MENU -->
		<?PHP includeMenu(2); ?>
		<div id="menu_main"> <!--
			<a href="cust_search.php">Search</a>
			<a href="cust_new.php" id="item_selected">New Customer</a>
			<a href="cust_act.php">Active Customers</a>
			<a href="cust_inact.php">Inactive Customers</a> -->
			<a href="cust_search.php">Back</a>
		</div>

		<!-- PAGE HEADING -->
		<p class="heading">New Customer (<?PHP echo $newCustNo; ?>)</p>
        
        <!-- New Customer Form -->
        <div class="newCustomerForm">
        <div class="ATCMFformcontainer">
        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>" method="post" enctype="multipart/form-data"> <!-- onSubmit="return validate(this)" -->
        <!-- action="cust_new.php" old -->
            
        <div class="ATCMFformrow">
            <div class="ATCMFformcol-20">
                <label for="cust_no">Customer Number (System Generated) :</label>           
            </div>
            <div class="ATCMFformcol-80">
                <input type="text" id="cust_no" name="cust_no" value="<?PHP echo $newCustNo; ?>" placeholder="Customer Number" readonly />
            </div>
        </div>
            
        <div class="ATCMFformrow">
            <div class="ATCMFformcol-20">
                <label for="cust_name">Full Name :</label>
            </div>
            <div class="ATCMFformcol-80">
                <span class="formError"><?php echo $cust_nameErr;?></span>
                <input type="text" id="cust_name" name="cust_name" placeholder="සම්පූර්ණ නම" value="<?php echo $cust_name;?>" />   
            </div>
        </div> 
            
        <div class="ATCMFformrow">
            <div class="ATCMFformcol-20">
                <label for="cust_address">Address :</label>             
            </div>
            <div class="ATCMFformcol-80">
                <span class="formError"><?php echo $cust_addressErr;?></span>
                <input type="text" id="cust_address" name="cust_address" placeholder="ලිපිනය" value="<?php echo $cust_address;?>" />
            </div>
        </div>
            
        <div class="ATCMFformrow">
            <div class="ATCMFformcol-20">
                <label id="cAddResPIDl" for="cAdRePMM">Period of residence at the above address ( ඉහත ලිපිනයේ පදිංචි කාලය ) :</label>         
            </div>
            <div class="ATCMFformcol-80">
                <div class="ATCMFformcol-25">
                    <input type="number" id="cAdRePMM" name="cAdRePMo" placeholder="Months : MM" value="<?php echo $Period_of_residenceAddM;?>" >
                </div>
                <div class="ATCMFformcol-25">
                    <input type="number"  name="cAdRePYe" placeholder="Years : YYYY" value="<?php echo $Period_of_residenceAddY;?>" >
                </div>   
            </div>
        </div>
            
        <div class="ATCMFformrow">
            <div class="ATCMFformcol-20">
                <label for="CustomerGND">Grama Niladhari Division</label>             
            </div>
            <div class="ATCMFformcol-80">
                <div class="autocomplete-container" > 
                    <span class="formError"><?php echo $CustomerGNDErr;?></span>
                    <input  type="text" id="CustomerGND" name="CustomerGND" placeholder="ග්‍රාම නිලධාරී වසම" value="<?php echo $CustomerGND;?>">
                </div>
                <script>
                    $( function() {
                    $( "#CustomerGND" ).autocomplete({
                    source: <?PHP
                        $arrCustomerGND = array(); 
                            while ($row_newCselectGND = mysqli_fetch_assoc($query_newCselectGND)){			
                                $data['id']    = $row_newCselectGND['id'];
                                $data['value'] = $row_newCselectGND['name']." (".$row_newCselectGND['district'].")";         
                                    array_push($arrCustomerGND, $data);
                                }
                                echo json_encode($arrCustomerGND);
                            ?> 
                    }); });
                </script>
            </div>
        </div>
            
        <div class="ATCMFformrow">
            <div class="ATCMFformcol-20">
                <label for="CustLocation">Customer Location</label>                  
            </div>
            <div class="ATCMFformcol-80">
                <input type="text" id="CustLocation" name="CustLocation" placeholder="ස්ථානය" value="<?php echo $CustLocation;?>" />
                <!-- Get Geo Location -->
                <div class="ATCMFformcol-25">
                    Latitude :<input type="text" id="lat" name="lat" readonly>
                </div>
                <div class="ATCMFformcol-25">
                    Longitude :<input  type="text" name="lng"  id="lng" readonly>
                </div>
                <div id="GeolocationErr"></div>
            </div>     
        </div>
            <script>
                var la = document.getElementById("lat");
                var ln = document.getElementById("lng");
                    function getLocation() {
                        if (navigator.geolocation) {
                            navigator.geolocation.getCurrentPosition(showPosition);
                        } else { 
                            GeolocationErr.innerHTML = "Geolocation is not supported by this browser.";
                        }
                    }
                    function showPosition(position) {
                        document.getElementById("lat").value = position.coords.latitude;
                        document.getElementById("lng").value = position.coords.longitude;
                    }
            </script>
        <!-- End Get Geo Location -->
            
        <div class="ATCMFformrow">
            <div class="ATCMFformcol-20">
                <label for="cust_nic">Customer NIC</label>        
            </div>
            <div class="ATCMFformcol-80">
                <span class="formError"><?php echo $CustNICErr;?></span>
                <input type="text"  id="cust_nic" name="cust_nic" placeholder="NIC" value="<?php echo $CustNIC;?>" />
            </div>
        </div>
            
        <div class="ATCMFformrow">
            <div class="ATCMFformcol-20">
                <label for="cust_dob">Date of Birth</label>
            </div>
            <div class="ATCMFformcol-80">
                <span class="formError"><?php echo $cust_dobErr;?></span>
                <input type="date" id="cust_dob" name="cust_dob" placeholder="උපන්දිනය" /> 
            </div>
        </div>
            
        <div class="ATCMFformrow">
            <div class="ATCMFformcol-20">
                <label for="custsex_id">Gender</label>
            </div>
            <div class="ATCMFformcol-80">
                <span class="formError"><?php echo $custsex_idErr;?></span>
                <select id="custsex_id" name="custsex_id" size="1" >';
                    <?PHP
                        while ($row_sex = mysqli_fetch_assoc($query_sex)){
                            echo '<option value="'.$row_sex['custsex_id'].'">'.$row_sex['custsex_name'].'</option>';
                        } ?>
				</select>
            </div>
        </div>
            
        <div class="ATCMFformrow">
            <div class="ATCMFformcol-20">
                <label for="custmarried_id">Marital Status</label>	                       
            </div>
            <div class="ATCMFformcol-80">
                <span class="formError"><?php echo $custmarried_idErr;?></span>
                <select id="custmarried_id" name="custmarried_id" size="1" >
                    <?PHP
                        while ($row_mstat = mysqli_fetch_assoc($query_mstat)){
                            echo '<option value="'.$row_mstat['custmarried_id'].'">'.$row_mstat['custmarried_status'].'</option>';
                        } ?>
                </select>  
                <div class="ATCMFformcol-25">
                    <i id="partnerNameL" >Partner Name : </i>
                    <input type="text" id="partnerName" name="partnerName"/>
                </div>
                <div class="ATCMFformcol-25">
                    <i id="partnerNICL" >Partner NIC : </i>
                    <input type="text" id="partnerNIC" name="partnerNIC"/>
                </div>
            </div>
             <script>
                 $( document ).ready(function() {
                     $('#partnerName').hide();      
                     $('#partnerNIC').hide();  
                        $('#partnerNameL').hide();      
                        $('#partnerNICL').hide(); 
                 });

                 $('#custmarried_id').on('change', function() {
                    if(this.value == '2'){
                    $('#partnerName').show();  
                    $('#partnerNIC').show();   
                        $('#partnerNameL').show();  
                        $('#partnerNICL').show();
                    }
                    else{
                     $('#partnerName').hide();      
                     $('#partnerNIC').hide();  
                        $('#partnerNameL').hide();      
                        $('#partnerNICL').hide(); 
                    }
                 }); 
            </script>
        </div>
            
        <div class="ATCMFformrow">
            <div class="ATCMFformcol-20">
                <label for="cust_occup">Customer Occupation</label>
            </div>
            <div class="ATCMFformcol-80">
                <input type="text" name="cust_occup" id="cust_occup" 
                placeholder="රැකියාව" value="<?php echo $cust_occup;?>" />
            </div>
        </div>
            
        <div class="ATCMFformrow">
            <div class="ATCMFformcol-20">
                <label for="ConNu1">Contact Numbers</label>
            </div>
            <div class="ATCMFformcol-80">
                <div class="ATCMFformcol-25">
                    <span class="formError"><?php echo $cust_phone1Err;?></span>
                    <input type="tel" id="ConNu1"  name="ConNu1" placeholder="ex : 0772345678" pattern="[0-9]{3}[0-9]{7}" value="<?php echo substr($cust_phone,0,10); ?>" /> 
                </div>
                <div class="ATCMFformcol-25">   
                    <input type="tel"  name="ConNu2" placeholder="ex : 0772345678" pattern="[0-9]{3}[0-9]{7}" value="<?php echo substr($cust_phone,11,21); ?>" />
                </div>
            </div>
        </div>
            
        <div class="ATCMFformrow">
            <div class="ATCMFformcol-20">
                <label for="cust_email">E-Mail</label>              
            </div>
            <div class="ATCMFformcol-80">
                <input type="text" id="cust_email" name="cust_email" placeholder="abc@xyz.com" value="<?php echo $cust_email;?>" />  
            </div>
        </div>
            
        <div class="ATCMFformrow">
            <div class="ATCMFformcol-20">
                <label for="loanroute_idNC" >Line</label>           
            </div>
            <div class="ATCMFformcol-80">
                <span class="formError"><?php echo $loanroute_idNCErr;?></span>
                <select name="loanroute_idNC" id="loanroute_idNC" size="1">
                    <?php
                        while ($row_loanrouteNC = mysqli_fetch_assoc($query_loanrouteNC)){
                            ?>
                            <option value="<?php echo $row_loanrouteNC['id']; ?>">
                                    <?php echo $row_loanrouteNC['name']." ( ".$row_loanrouteNC['description'].")"; ?>
                            </option>
				    <?php  } ?>
                </select>
            </div>            
        </div>
        
        <input type="hidden" id="datepicker2" name="cust_since" value="<?PHP echo date("d.m.Y", $timestamp) ?>" />   
        <input type="hidden" name="receipt_no" id="receipt_no" value="" />
        
        <div class="ATCMFformrow">
            <div class="ATCMFformcol-100">    
		      <input type="submit" name="create" value="Submit" /> 
            </div>
        </div>    
        </form>
        </div>
        </div>
                 
        <?php include 'views/partial/footer.php'; ?>
        <script src="js/atcMFmainJS.js"></script>
	</body>
</html>
